function [chan,t_out,o_out,flprot_idx] = syn_align_all2(ori,termi,third,dist)
%This function takes all of the synapses vectors and rotates all of them
%onto a single axis so we can super impose all of the other channel
%verticies together.  This version picks the closest point.
%Synatax:   [c_out,t_out,o_out,flprot_idx] = syn_align_all(ori,termi,chan);
%Input:     ori = a list of vertices.  Note: if an array have more than
%               3 columns, only the first three will be considered.  Ori
%               will be come 0,0,0.  Use the overts output from
%               punc_colo_all.
%           termi = list of vertices.  Will become x1,0,x2.  Use the tverts
%               output from punc_colo_all.
%           third = ok modifed, now for this chan_tmp is a cell array,
%               essentially it will take a slice from all_data.all_termi.
%           dist = the matching distance cell array for the third channel.
%Output:    t_out = the rotated termi vertices.
%           chan = the rotated chan vertices.If cell array will match cell
%               dimensions.
%           o_out = the translated origin vertices list all 0 0 0.
%           flprot_idx = The x,z flip rotation indexes.

%Translate all the points first
o_tmp = zeros(size(ori,1),3); %translate ori to 0,0,0.  This is assuming that all vertices are positive, which for an image should be true.
t_tmp = termi(:,1:3)-ori(:,1:3);    %translate termi
%translate third
parpool      %lets get massive
parfor j = 1:size(ori,1)
    curr_cell = third{ori(j,4)};    %find the current cell in the third channel.  Use the ordinals to pick the cell
    curr_dist = dist{ori(j,4)};
    c_tmp{j,1} = horzcat(curr_cell(:,1:3)-repmat(ori(j,1:3),size(curr_cell,1),1),curr_dist);       %translate channels & add distance
end

%fix one last thing, rotate all negative x's to positive, 180 flip,
%because we are enforcing directionality
flpx_idx = t_tmp(:,1)<0;   %create the flip index: 1 will flip and 0 will not
flpx_mtrx = ones(size(t_tmp,1),1);     %create flip matrix for x
flpx_mtrx(flpx_idx,:) = -1;
%modify termial point
t_tmp(:,1) = t_tmp(:,1).*flpx_mtrx;
t_tmp(:,2) = t_tmp(:,2).*flpx_mtrx;     %y is flipped as well for a 180 turn
%modify channel points (third points)
parfor m = 1:size(c_tmp,1)
    c_tmp{m,1}(:,1) = c_tmp{m,1}(:,1)*flpx_mtrx(m,1);      %rotate 180deg x
    c_tmp{m,1}(:,2) = c_tmp{m,1}(:,2)*flpx_mtrx(m,1);      %rotate 180deg y
end

%parallelize
%matlabpool

%Now calculate the angle of rotation on the x axis
%calculate vector 1, ori - termi  rotated
v1 = horzcat(hypot(t_tmp(:,1),t_tmp(:,2)),zeros(size(t_tmp,1),1));   %rotating the syn axis to x 0, everything will be aligned to the y axis
v2 = t_tmp(:,[1 2]);      %the origial 
parfor m = 1:size(v1,1)    %calculate the dot product for each pair of vectors
    x_rot(m,1) = dot(v2(m,:),v1(m,:));     %calculate the dot product, which gives us the cos of the angle
end
%x_rot = acos(x_rot./(hypot(v1(:,1),v1(:,2)).*hypot(v2(:,1),v2(:,2)))).*180/pi;        %calculate the angles in degress.
x_rot = acosd(single(x_rot)./single(hypot(v1(:,1),v1(:,2)).*hypot(v2(:,1),v2(:,2))));        %calculate the angles in degress.
%find the clockwise rotations
neg_idx = ones(size(t_tmp,1),1);           %start the index
neg_idx(t_tmp(:,2)>0) = -1;        %clockwise rotation is -degree angle of rotation
%modify rotation angles
x_rot = x_rot.*neg_idx;         %clockwise and counter clockwise set.
%rotate the base vector
parfor m = 1:size(x_rot,1)
    x_tmp(m,:) = ([cosd(x_rot(m,1)),-sind(x_rot(m,1));sind(x_rot(m,1)),cosd(x_rot(m,1))]*[t_tmp(m,1);t_tmp(m,2)])';
end
t_tmp(:,1) = x_tmp(:,1);
%calculte the angle of roation on the z axis
v3 = horzcat(hypot(t_tmp(:,1),t_tmp(:,3)),zeros(size(t_tmp,1),1));   %rotating the syn axis to z 0
v4 = t_tmp(:,[1 3]);      %the origial vector
parfor n = 1:size(v1,1)        %Dot product per pair of vectors
    z_rot(n,1) = dot(v4(n,:),v3(n,:));     %calculate the dot product, which gives us the cos of the angle
end
%z_rot = acos(z_rot./(hypot(v3(:,1),v3(:,2)).*hypot(v4(:,1),v4(:,2)))).*180/pi;        %calculate the angles in degress.
z_rot = acosd(single(z_rot)./single(hypot(v3(:,1),v3(:,2)).*hypot(v4(:,1),v4(:,2))));        %calculate the angles in degress.
%find the clockwise rotations
neg_idx = ones(size(t_tmp,1),1);           %start the index
neg_idx(t_tmp(:,3)>0) = -1;        %clockwise rotation is -degree angle of rotation
%modify rotation angles
z_rot = z_rot.*neg_idx;         %clockwise and counter clockwise set.

%now rotate the third points
chan = [];      %initialize
%h = waitbar(0,'Rotating Vector: 0');    %initialize progress bar.
parfor k = 1:size(c_tmp,1)
    %waitbar(k/size(c_tmp,1),h,['Rotating Vector: ' num2str(k)]);   %update progress
    curr_cell = c_tmp{k,1};    %find the current cell in the third channel. 
    %now find the nearest third point: sort by distance
    curr_cell = sortrows(curr_cell,4);
    curr_cell = curr_cell(1,:);     %pick the nearest    
    rotx_tmp = [cosd(x_rot(k,1)),-sind(x_rot(k,1));sind(x_rot(k,1)),cosd(x_rot(k,1))]*curr_cell(1,[1 2])';    %rotation in x plane
    rotz_tmp = [cosd(z_rot(k,1)),-sind(z_rot(k,1));sind(z_rot(k,1)),cosd(z_rot(k,1))]*[rotx_tmp(1) curr_cell(1,3)]';    %more acurate for x, but not z???
    chan_tmp = [rotz_tmp(1) rotx_tmp(2) rotz_tmp(2)];        %store new rotated vertex.
    chan_tmp(isnan(chan_tmp)) = 0;      %Nan is 0
    chan = vertcat(chan,chan_tmp);      %create the rotated third channel, we no longer need the structure of c_tmp or ori or termi, unbound.
    chan_tmp = [];
end
%close(h);   %close progress bar
delete(gcp('nocreate'))    %done

%output termi and ori
if size(termi,2)==3     %no extra data, just the vertex
    t_out = [hypot(t_tmp(:,1),hypot(t_tmp(:,2),t_tmp(:,3))),zeros(size(t_tmp,1),2)];
    o_out = o_tmp;
else                    %extra data, concatenate into the matrix
    t_out = horzcat([t_tmp(:,1),zeros(size(t_tmp,1),1),t_tmp(:,3)],termi(:,end-(size(termi,2)-3):end));
    o_out = horzcat(o_tmp,ori(:,end-(size(ori,2)-3):end));
end
%output flprot_idx
flprot_idx = [flpx_idx x_rot z_rot];
% %save to CSV or not.
% uconfirm = yes_no_box('title','Do you want to save the data?','caption1','Select yes to save as a CSV file',...
%     'caption2','Select no if you are not interested','position','center');
% if uconfirm==1      %save data as an excel file
%     %localization for macs
%     if ispc
%         slash = '\';        %Windows directory marker
%     else
%         slash = '/';        %Mac directory marker
%     end
%     %ok now find the points & the brightness
%     [filename,pathname,filterindex] = uiputfile('.csv');
%     mkdir(pathname,'aligned');      %create output directory
%     %now save the files
%     %termi first
%     data_exp = dataset(t_out);               %to export you need to make the data a dataset.
%     export(data_exp,'File',[[pathname,'aligned',slash,filename(1:end-4)],'_termi.csv'],'delimiter',',')
%     %ori next
%     data_exp = dataset(o_out);               %to export you need to make the data a dataset.
%     export(data_exp,'File',[[pathname,'aligned',slash,filename(1:end-4)],'_ori.csv'],'delimiter',',')
%     %channels
%     for m = 1:size(chan,2)
%         data_exp = dataset(chan{m});
%         export(data_exp,'File',[[pathname,'aligned',slash,filename(1:end-4)],['_chan',num2str(m),'.csv']],'delimiter',',')
%         %clear data
%         data_exp = [];
%     end
%     %finally the rotation indxe
%     data_exp = dataset(flprot_idx);               %to export you need to make the data a dataset.
%     export(data_exp,'File',[[pathname,'aligned',slash,filename(1:end-4)],'_flprot.csv'],'delimiter',',')
% end
%matlabpool close